function [f1,f2]=doFigure1(AMTR,ax1,ax2,loc,name,tax)

%NBER dates
pks   = [1948.75 1953.25 1957.50 1960.25 1969.75 1973.75 1980.00 1981.50 ...
    1990.50 2001.00 2007.75];
thrs  = [1949.75 1954.25 1958.25 1961.00 1970.75 1975.00 1980.50 1982.75 ...
    1991.00 2001.75 2009.25];

f1 = figure;
for j=1:length(pks)   
 Y=[ax1(1) ax1(1) ax1(2) ax1(2) ]*100;
 X=[pks(j),thrs(j),thrs(j),pks(j)];
 h=fill(X,Y, [0.9 0.9 0.9]); 
 set(h,'EdgeColor','None');
 hold on 
 end
p1=plot(AMTR(:,1),AMTR(:,2)*100,'-','LineWidth',2,'Color', [0.9 0 0],'MarkerSize',3,'MarkerFaceColor',[0.9 0 0]);
hold on 
p2=plot(AMTR(:,1),AMTR(:,3)*100,'--','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
hold on 
set(gca,'XTick',1945:5:2010);
axis([1945 2013  ax1(1)*100-0.1 ax1(2)*100*(1.005)]);
l = legend([p1 p2],'Barro and Redlick (2011) Income Definition','Piketty and Saez (2003) Income Definition');
yl= ylabel('percent');
set([yl,l], 'FontName', 'AvantGarde','Fontsize',8);
if loc==0
set(l,'Location','NorthWest','Fontsize',8,'EdgeColor','white')
elseif loc==1
set(l,'Location','SouthEast','Fontsize',8,'EdgeColor','white')
elseif loc==2
set(l,'Location','NorthWest','Fontsize',8,'EdgeColor','white')
end
ti=title(strcat('All Tax Units ', tax));
set([ti], 'FontName', 'AvantGarde','FontWeight','bold','Fontsize',10);

hold off

str=strcat('figures\',name,'ALL');
saveas(gcf,str,'epsc');
 
f2 = figure;
for j=1:length(pks)   
  Y=[ax2(1) ax2(1) ax2(2) ax2(2) ]*100;
 X=[pks(j),thrs(j),thrs(j),pks(j)];
 h=fill(X,Y, [0.9 0.9 0.9]) ;
 set(h,'EdgeColor','None');
 hold on 
 end
for j = [4:10]
X1  = AMTR(:,1);
Y1  = AMTR(:,j)*100;
    if j == 4
    p1=plot(X1,Y1,'-','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on 
    elseif j == 5
    p2=plot(X1,Y1,'--','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on 
    elseif j == 6
    p3=plot(X1,Y1,'-.','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on 
    elseif j == 7
    p4=plot(X1,Y1,':','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on  
    elseif j == 8
    p5=plot(X1,Y1,'-o','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on
    elseif j == 9
    p6=plot(X1,Y1,'--s','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on  
    elseif j == 10
    p7=plot(X1,Y1,':d','LineWidth',2,'Color', [0 0 0.5],'MarkerSize',3,'MarkerFaceColor',[0 0 0.5]);
    hold on
    hold on  
    end
end
%   1    2    3    4    5     6     7         8         9         10
% DATES ALL1 ALL2 TOP1 TOP5 TOP10  TOP5-1    TOP10-5    BOTTOM99  BOTTOM90;

set(gca,'XTick',1945:5:2010);
axis([1945 2013  ax2(1)*100-0.1 ax2(2)*100*(1.005)]);
l=legend([p1 p2 p3 p4 p5 p6 p7],'Top 1%','Top 5%','Top 10%','Top 5% to 1%','Top 10% to 5%','Bottom 99%','Bottom 90%');
yl= ylabel('percent');
ti=title(strcat('Top and Bottom Tax Units ', tax));
set([ti], 'FontName', 'AvantGarde','FontWeight','bold','Fontsize',10);
set([yl,l], 'FontName', 'AvantGarde','Fontsize',8);
if loc==0||loc==1
set(l,'Location','NorthEast','EdgeColor','white')
elseif loc==2
set(l,'Location','NorthWest','EdgeColor','white')
end

str=strcat('figures\',name,'TB');
saveas(gcf,str,'epsc');

